﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultPerformancePlugin.Controls.Strategy;

namespace WinfootDefaultPerformancePlugin.Controls
{
    public partial class AdditionalWorkerThreads : UserControl, ICorrespondenceOS, IControl
    {
        private AdditionalWorkerThreadsController additionalWorkerThreadsController;

        public AdditionalWorkerThreads()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsVista_SP3,
#if DEBUG
                                           OS.WindowsSeven,
                                           OS.WindowsSeven_SP1,
                                           OS.WindowsSeven_SP2,
#endif
                                       };
            
        }

        public void SetWorkerThreadValue(List<WFRegistry> wfRegistries)
        {
            numericUpDown1.Value = Convert.ToDecimal(wfRegistries[0].Value);
            numericUpDown2.Value = Convert.ToDecimal(wfRegistries[1].Value);
        }

        public List<int> GetWorkerThreadValue()
        {
            return new List<int>{ Convert.ToInt32(numericUpDown1.Value), Convert.ToInt32(numericUpDown2.Value) };
        }

        void groupBox1_MouseClick(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:performance:additionalworkerthreads"));
                userHelp.Show();
            }
        }

        #region IControl メンバ

        public void Apply()
        {
            additionalWorkerThreadsController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return additionalWorkerThreadsController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void AdditionalWorkerThreads_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            additionalWorkerThreadsController = new AdditionalWorkerThreadsController(this,
                                                                                    (IAdditionalWorkerThreadsStrategy)
                                                                                    wfUtillity.GetCorrespondenceInstance
                                                                                        (new List<ICorrespondenceOS>
                                                                                             {
                                                                                                 new AdditionalWorkerThreadsDefaultStrategy()
                                                                                             }));
            additionalWorkerThreadsController.Read();
        }
    }
}